require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};


MakeDialog
{
    Bitmap
    { 
        image="backgrounds/dialog",
        x=kCenter,
        y=kCenter,
        
        Text
        {
            font = MyFont,
            name = "entername",
            x=0,y=20,w=kMax,h=30 * 3,
            flags = kHAlignCenter + kVAlignTop,
            label = "enterlevnum"
        };
        
        Bitmap
        {
            image="backgrounds/textfield.png",
            x=kCenter,
            y=kCenter,
            
            TextEdit
            {
                font = NameFont,
                name = "cheat_ln_edit",
                label = "",
                enablewindow = "enterok",
                clearinitial = true,
                x=3,y=5,w=kMax-3,h=kMax,
                length=5,
                ignore = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM "
                
            };
        };
            
        Button
        {
            x=50,
            y=-60,
            font = StandardButtonFont,
            graphics = StandardButtonGraphics,
            name="enterok",
            label="ok",
            type = kPush,
            default=true,   -- Make this the default button
            command = 
                function()
                    if (GetLabel("cheat_ln_edit") ~= "") then
                        local num_obj = tonumber(GetLabel("cheat_ln_edit"));
                        if (num_obj >= mMinCheatValue and num_obj <= mMaxCheatValue) then
                            CloseWindow(GetLabel("cheat_ln_edit"));
                            PopModal( "bonus_dialog" );                            
                            CPP_OnDopCheatAction(num_obj);
                        else
                            DisplayDialog { "scripts/ok.lua", body ="error_cheat_dialog",title = ""};
                            SetFocus( "nameedit" )
                        end
                    else
                        DisplayDialog { "scripts/ok.lua", body ="error_cheat_dialog",title = "" };
                        SetFocus( "nameedit" )
                    end
                end
        },
        
        Button
        {
            x=250,
            y=-60,
            font = StandardButtonFont,
            graphics = StandardButtonGraphics,
            name="entercancel",
            label="cancel",
            type = kPush,
            command = 
                function()
                    CloseWindow(nil);
                end
        };
    },
    
}
EnableWindow("enterok",false);
SetLabel("entername",mCheatText);
SetFocus( "cheat_ln_edit" );
--SetLabel("cheat_ln_edit","1");


